"use client"

import { useState, useEffect } from "react"

interface TimerProps {
  roundStartTime: number | null
  userVoted: boolean
}

export default function Timer({ roundStartTime, userVoted }: TimerProps) {
  const [timeLeft, setTimeLeft] = useState(20)
  const [isWarning, setIsWarning] = useState(false)

  useEffect(() => {
    if (!roundStartTime) {
      setTimeLeft(20)
      return
    }

    const updateTimer = () => {
      const now = Date.now()
      const elapsed = now - roundStartTime
      const remaining = Math.max(0, 20000 - elapsed)
      const secondsLeft = Math.ceil(remaining / 1000)

      setTimeLeft(secondsLeft)
      setIsWarning(secondsLeft <= 5)
    }

    updateTimer()
    const interval = setInterval(updateTimer, 1000)

    return () => clearInterval(interval)
  }, [roundStartTime])

  return (
    <div
      className="relative p-2 sm:p-4 text-center text-white rounded-lg mb-2 sm:mb-4 overflow-hidden"
      style={{
        backgroundImage: "url('/images/bg-3.jpg')",
        backgroundSize: "cover",
        backgroundPosition: "center",
      }}
    >
      <div className="relative z-10">
        <span className="text-sm sm:text-lg mr-2">⏱</span>
        <span className={`text-sm sm:text-lg font-bold ${isWarning ? "text-red-400" : "text-white"}`}>
          {userVoted ? "Waiting for next round..." : `${timeLeft}s before voting ends`}
        </span>
      </div>
    </div>
  )
}
