"use client"

interface HistoryPanelProps {
  results: string[]
}

export default function HistoryPanel({ results }: HistoryPanelProps) {
  const renderGrid = () => {
    const columns = 12
    const rows = 7
    const totalResults = results.length
    const gridItems = []

    // Fill the grid from top to bottom, left to right (newest results first)
    for (let col = 1; col <= columns; col++) {
      for (let row = 1; row <= rows; row++) {
        const gridPosition = (col - 1) * rows + (row - 1)
        const resultIndex = gridPosition

        let content = null
        if (resultIndex >= 0 && resultIndex < totalResults) {
          const result = results[resultIndex]
          let imageSrc = ""

          if (result === "H") {
            imageSrc = "/images/banker.png" // Red coin for Heads/Banker
          } else if (result === "T") {
            imageSrc = "/images/player.png" // Blue coin for Tails/Player
          }

          if (imageSrc) {
            content = (
              <img
                src={imageSrc || "/placeholder.svg"}
                alt={result === "H" ? "Banker" : "Player"}
                className="w-4 h-4 sm:w-6 md:w-8 sm:h-6 md:h-8 object-contain"
              />
            )
          }
        }

        gridItems.push(
          <div
            key={`${col}-${row}`}
            className="w-full h-full flex items-center justify-center border border-amber-200"
            style={{
              gridRow: row,
              gridColumn: col,
              backgroundColor: "#f5f1e8",
            }}
          >
            {content}
          </div>,
        )
      }
    }

    return gridItems
  }

  return (
    <div
      className="relative p-2 sm:p-4 md:p-8 rounded-lg mb-2 sm:mb-4 overflow-hidden min-h-[200px] sm:min-h-[300px] md:min-h-[400px]"
      style={{ backgroundColor: "#f5f1e8" }}
    >
      <div
        className="grid gap-0 w-full h-full"
        style={{
          gridTemplateColumns: "repeat(12, 1fr)",
          gridTemplateRows: "repeat(7, 1fr)",
          height: "180px",
          aspectRatio: "12/7",
        }}
      >
        {renderGrid()}
      </div>
    </div>
  )
}
