interface Props {
  elapsedTime: number;
  bettingCountdown: number | null;
}

const Header = ({ elapsedTime, bettingCountdown }: Props) => {
  return (
    <div className="flex flex-row justify-between items-center bg-[url('/images/bg-3.jpg')] pr-4 py-4 pl-2 bg-cover bg-center bg-no-repeat gap-4">
      {/* Countdown Status */}
      <div className="flex flex-row items-center text-white gap-2 sm:gap-3 text-center sm:text-left">
        {bettingCountdown === null ? (
          <span className="text-gray-400 text-[2.5vw] sm:text-2xl font-impact">
            Waiting for round...
          </span>
        ) : bettingCountdown > 10 ? (
          <>
            <h1 className="text-[5.5vw] sm:text-3xl font-impact">
              {elapsedTime.toFixed(1)}s
            </h1>
            <span className=" text-[3.5vw] sm:text-2xl font-impact">
              elapsed time
            </span>
          </>
        ) : bettingCountdown > 0 ? (
          <div className="flex flex-col justify-center items-center">
            <span className=" text-[3vw] sm:text-xl">Bets Closing in</span>
            <span className="text-red-500 text-2xl sm:text-3xl font-impact animate-pulse">
              {Math.ceil(bettingCountdown)}
            </span>
          </div>
        ) : (
          <span className="text-red-600 text-[3vw] sm:text-3xl font-impact">
            BETTING CLOSED
          </span>
        )}
      </div>

      {/* Right Side: Live Shoe Feed & Location */}
      <div className="text-center sm:text-right">
        <div className="flex justify-around items-center gap-2 sm:gap-4 bg-[#7b1d17] rounded-full px-3 ">
          <h2 className="text-[#f30303] tracking-widest   text-[3vw] sm:text-xl font-impact">
            LIVE SHOE FEED
          </h2>
          <div className="relative size-2 sm:size-3">
            <span className="absolute inset-0 h-full w-full rounded-full bg-[#5afd01] opacity-75 animate-ping"></span>
            <span className="absolute inset-0 m-auto rounded-full bg-[#5afd01] size-2 sm:size-3"></span>
          </div>
        </div>
        <div className="flex justify-center sm:justify-end items-center gap-2 mt-2 ">
          <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 24 24"
            fill="white"
            className="lucide lucide-map-pin-icon lucide-map-pin h-3 w-3 sm:h-6 sm:w-6"
          >
            <path d="M20 10c0 4.993-5.539 10.193-7.399 11.799a1 1 0 0 1-1.202 0C9.539 20.193 4 14.993 4 10a8 8 0 0 1 16 0" />
            <circle cx="12" cy="10" r="3" fill="black" />
          </svg>
          <p className="text-white text-[2.5vw] sm:text-sm font-roboto-condensed">
            San Diego, CA - ??? Casino
          </p>
        </div>
      </div>
    </div>
  );
};

export default Header;
