"use client";

interface CommunityPredictionProps {
  communityBankerPercentage: number;
  communityPlayerPercentage: number;
}

export default function CommunityPrediction({
  communityBankerPercentage,
  communityPlayerPercentage,
}: CommunityPredictionProps) {
  return (
    <div className=" bg-black">
      <div className="p-2 md:p-4">
        <h2 className="text-white text-[2.5vw] sm:text-sm  font-poppins mb-4">
          Community Prediction
        </h2>

        <div className="flex items-center gap-3 mb-3">
          <span className="text-white text-xs sm:text-md font-impact w-20">
            Banker
          </span>
          <div className="flex-1 bg-black rounded-full h-6 sm:h-8 relative overflow-hidden">
            <div
              className="bg-red-600 h-full rounded-full flex items-center justify-center px-1 sm:px-4   sm:py-0"
              style={{ width: `${Math.max(communityBankerPercentage, 10)}%` }}
            >
              <span className="text-white text-xs sm:text-md font-impact mr-auto">
                {communityBankerPercentage}%
              </span>
            </div>
          </div>
        </div>

        {/* Player Row */}
        <div className="flex items-center gap-3">
          <span className="text-white text-sm sm:text-md font-impact w-20">
            Player
          </span>
          <div className="flex-1 bg-black rounded-full h-6 sm:h-8 relative overflow-hidden">
            <div
              className="bg-sky-400 h-full rounded-full flex items-center justify-center px-3 sm:px-4"
              style={{ width: `${Math.max(communityPlayerPercentage, 5)}%` }}
            >
              <span className="text-white text-xs sm:text-md font-impact mr-auto">
                {communityPlayerPercentage}%
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}
