"use client"

interface CasinoTimerProps {
  elapsedTime: number
  betsClosing: boolean
}

export default function CasinoTimer({ elapsedTime, betsClosing }: CasinoTimerProps) {
  const timeLeft = Math.max(0, 20 - elapsedTime)

  if (betsClosing) {
    return (
      <div className="bg-red-900 border-2 border-red-600 rounded-lg p-4 text-center">
        <div className="flex items-center justify-center gap-2">
          <div className="w-3 h-3 bg-red-500 rounded-full animate-pulse"></div>
          <span className="text-red-200 font-bold">LIVE SHOE FEED</span>
          <span className="text-xs text-red-300">📍 San Diego, CA - ????? Casino</span>
        </div>
        <div className="mt-2">
          <span className="text-2xl font-bold text-white">Bets Closing in {timeLeft}</span>
        </div>
      </div>
    )
  }

  return (
    <div className="bg-amber-900 border-2 border-amber-600 rounded-lg p-4 text-center">
      <div className="flex items-center justify-center gap-2">
        <div className="w-3 h-3 bg-green-500 rounded-full animate-pulse"></div>
        <span className="text-amber-200 font-bold">LIVE SHOE FEED</span>
        <span className="text-xs text-amber-300">📍 San Diego, CA - ????? Casino</span>
      </div>
      <div className="mt-2">
        <span className="text-2xl font-bold text-white">{elapsedTime}.1s elapsed time</span>
      </div>
    </div>
  )
}
