"use client"

interface CasinoGameBoardProps {
  results: string[]
  currentRound: number
  maxRounds: number
  votes: { heads: number; tails: number }
}

export default function CasinoGameBoard({ results, currentRound, maxRounds, votes }: CasinoGameBoardProps) {
  const playerCount = results.filter((r) => r === "T").length
  const bankerCount = results.filter((r) => r === "H").length
  const tieCount = results.filter((r) => r === "TIE").length

  const totalVotes = votes.heads + votes.tails
  const playerPercentage = totalVotes > 0 ? Math.round((votes.tails / totalVotes) * 100) : 50
  const bankerPercentage = totalVotes > 0 ? Math.round((votes.heads / totalVotes) * 100) : 50

  const renderResultsGrid = () => {
    const gridItems = []
    const columns = 12
    const rows = 7

    for (let col = 0; col < columns; col++) {
      for (let row = 0; row < rows; row++) {
        const index = col * rows + row
        const result = results[index]

        gridItems.push(
          <div
            key={`${col}-${row}`}
            className="w-8 h-8 border border-amber-200 bg-amber-50 flex items-center justify-center"
          >
            {result && (
              <div
                className={`w-6 h-6 rounded-full ${
                  result === "T" ? "bg-blue-500" : result === "H" ? "bg-red-500" : "bg-green-500"
                }`}
              />
            )}
          </div>,
        )
      }
    }

    return gridItems
  }

  return (
    <div className="bg-amber-900 border-2 border-amber-600 rounded-lg p-4">
      {/* Score Display */}
      <div className="grid grid-cols-5 gap-2 mb-4">
        <div className="bg-blue-600 text-white p-2 rounded text-center">
          <div className="flex items-center justify-center gap-2">
            <div className="w-4 h-4 bg-blue-400 rounded-full"></div>
            <span className="font-bold">PLAYER</span>
            <span className="text-xl">{playerCount}</span>
          </div>
        </div>
        <div className="bg-red-600 text-white p-2 rounded text-center">
          <div className="flex items-center justify-center gap-2">
            <div className="w-4 h-4 bg-red-400 rounded-full"></div>
            <span className="font-bold">BANKER</span>
            <span className="text-xl">{bankerCount}</span>
          </div>
        </div>
        <div className="bg-yellow-600 text-white p-2 rounded text-center">
          <div className="flex items-center justify-center gap-2">
            <span className="text-lg">⭐</span>
            <span className="font-bold">DRAGONS</span>
            <span className="text-xl">0</span>
          </div>
        </div>
        <div className="bg-cyan-600 text-white p-2 rounded text-center">
          <div className="flex items-center justify-center gap-2">
            <span className="text-lg">🐼</span>
            <span className="font-bold">PANDA</span>
            <span className="text-xl">0</span>
          </div>
        </div>
        <div className="bg-green-600 text-white p-2 rounded text-center">
          <div className="flex items-center justify-center gap-2">
            <span className="text-lg">🤝</span>
            <span className="font-bold">TIES</span>
            <span className="text-xl">{tieCount}</span>
          </div>
        </div>
      </div>

      {/* Community Prediction */}
      <div className="flex gap-1 mb-4">
        <div className="bg-red-500 text-white px-3 py-1 rounded text-sm font-bold">{bankerPercentage}%</div>
        <div className="bg-blue-500 text-white px-3 py-1 rounded text-sm font-bold">{playerPercentage}%</div>
        <div className="bg-green-500 text-white px-3 py-1 rounded text-sm font-bold">1%</div>
        <div className="ml-auto bg-amber-700 text-white px-3 py-1 rounded text-sm font-bold">
          Hand {currentRound} of {maxRounds}
        </div>
      </div>

      {/* Results Grid */}
      <div className="grid grid-cols-12 gap-1 mb-4">{renderResultsGrid()}</div>

      {/* Betting Areas */}
      <div className="grid grid-cols-2 gap-4">
        <div className="bg-blue-700 text-white p-6 rounded-lg text-center">
          <h3 className="text-2xl font-bold">PLAYER</h3>
        </div>
        <div className="bg-red-700 text-white p-6 rounded-lg text-center">
          <h3 className="text-2xl font-bold">BANKER</h3>
        </div>
      </div>
    </div>
  )
}
