"use client"

interface CasinoBettingPanelProps {
  onVote: (choice: string) => void
  userVoted: boolean
  betsClosing: boolean
  votes: { heads: number; tails: number }
}

export default function CasinoBettingPanel({ onVote, userVoted, betsClosing, votes }: CasinoBettingPanelProps) {
  const totalVotes = votes.heads + votes.tails
  const bankerPercentage = totalVotes > 0 ? Math.round((votes.heads / totalVotes) * 100) : 0
  const playerPercentage = totalVotes > 0 ? Math.round((votes.tails / totalVotes) * 100) : 0

  return (
    <div className="bg-gray-800 border-2 border-gray-600 rounded-lg p-4">
      <h3 className="text-lg font-bold mb-4 text-center">Community Prediction</h3>

      <div className="space-y-3">
        <div className="flex items-center gap-2">
          <span className="text-sm font-bold min-w-[60px]">Banker:</span>
          <div className="flex-1 h-6 bg-gray-700 rounded overflow-hidden">
            <div className="h-full bg-red-500 transition-all duration-500" style={{ width: `${bankerPercentage}%` }} />
          </div>
          <span className="text-sm font-bold min-w-[40px]">{bankerPercentage}%</span>
        </div>

        <div className="flex items-center gap-2">
          <span className="text-sm font-bold min-w-[60px]">Player:</span>
          <div className="flex-1 h-6 bg-gray-700 rounded overflow-hidden">
            <div className="h-full bg-blue-500 transition-all duration-500" style={{ width: `${playerPercentage}%` }} />
          </div>
          <span className="text-sm font-bold min-w-[40px]">{playerPercentage}%</span>
        </div>
      </div>

      <div className="mt-6 space-y-3">
        <button
          onClick={() => onVote("tails")}
          disabled={userVoted || betsClosing}
          className={`w-full py-3 rounded font-bold transition-all ${
            userVoted || betsClosing
              ? "bg-gray-600 text-gray-400 cursor-not-allowed"
              : "bg-blue-600 hover:bg-blue-700 text-white"
          }`}
        >
          Bet on Player
        </button>

        <button
          onClick={() => onVote("heads")}
          disabled={userVoted || betsClosing}
          className={`w-full py-3 rounded font-bold transition-all ${
            userVoted || betsClosing
              ? "bg-gray-600 text-gray-400 cursor-not-allowed"
              : "bg-red-600 hover:bg-red-700 text-white"
          }`}
        >
          Bet on Banker
        </button>
      </div>

      {(userVoted || betsClosing) && (
        <div className="mt-4 p-3 bg-yellow-900 border border-yellow-600 rounded text-center">
          <span className="text-yellow-200 text-sm font-bold">
            {betsClosing ? "Bets are closed!" : "You have placed your bet"}
          </span>
        </div>
      )}
    </div>
  )
}
