"use client";

import Header from "@/components/header";
import { GameResult, TopGridBoard } from "@/components/top-grid-board";
import PercentageBar from "@/components/percentage-bar";
import { BottomGridBoard, Outcome } from "@/components/bottom-grid-board";
import VotingInterface from "@/components/voting-interface";
import CommunityPrediction from "@/components/community-prediction";
import { useGameState } from "@/hooks/useGameState";
import { useTimers } from "@/hooks/useTimers";
import {
  calculateUserScoreAndStats,
  calculateDisplayPercentages,
  calculateCommunityPercentages,
} from "@/lib/utils";

const Page = () => {
  const { gameState, submitVote } = useGameState();
  const { elapsedTime, bettingCountdown } = useTimers(
    gameState.roundStartTime,
    gameState.bettingDurationSeconds
  );

  const { correct, incorrect, sessionScore, stats } =
    calculateUserScoreAndStats(gameState);

  const {
    displayPlayerPercentage,
    displayBankerPercentage,
    displayTiePercentage,
  } = calculateDisplayPercentages(gameState);

  const { communityBankerPercentage, communityPlayerPercentage } =
    calculateCommunityPercentages(gameState);

  return (
    <div className="min-h-screen flex justify-center bg-[url('/images/bg-3.jpg')] bg-cover bg-center bg-no-repeat">
      <div className="w-full max-w-screen-sm mx-auto border-x border-white rounded-xl shadow-lg overflow-hidden">
        <Header elapsedTime={elapsedTime} bettingCountdown={bettingCountdown} />

        <TopGridBoard
          results={gameState.results as GameResult[]}
          stats={stats}
        />

        <PercentageBar
          playerPercentage={displayPlayerPercentage}
          bankerPercentage={displayBankerPercentage}
          tiePercentage={displayTiePercentage}
          currentHand={gameState.currentRound}
          totalHands={gameState.maxRounds}
        />

        <BottomGridBoard results={gameState.results as Outcome[]} />

        <div className="flex mb-1 w-full">
          <div className="w-[60%]">
            <VotingInterface
              correct={correct}
              incorrect={incorrect}
              sessionScore={sessionScore}
              onSubmitVote={submitVote}
              disabled={
                gameState.userVoted ||
                bettingCountdown === 0 ||
                bettingCountdown === null
              }
            />
          </div>

          <div className="w-[40%]">
            <CommunityPrediction
              communityBankerPercentage={communityBankerPercentage}
              communityPlayerPercentage={communityPlayerPercentage}
            />
          </div>
        </div>
      </div>
    </div>
  );
};

export default Page;
